(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4331,        121]*)
(*NotebookOutlinePosition[      5174,        148]*)
(*  CellTagsIndexPosition[      5130,        144]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 10.7 \( \(.1\)\(.\)\)*) \[IndentingNewLine]\(e[m_] := \ 
        Sqrt[m]\ Log[m]\ Exp[\(-Sqrt[\[Pi]^2\ m/4]\)];\)\), "\n", 
    \(Table[e[m], \ {m, 2, 10, 2}]\)}], "Input"],

Cell[BoxData[
    \({\@2\ E\^\(-\(\[Pi]\/\@2\)\)\ Log[2], 2\ E\^\(-\[Pi]\)\ Log[4], 
      \@6\ E\^\(\(-\@\(3\/2\)\)\ \[Pi]\)\ Log[6], 
      2\ \@2\ E\^\(\(-\@2\)\ \[Pi]\)\ Log[8], 
      \@10\ E\^\(\(-\@\(5\/2\)\)\ \[Pi]\)\ Log[10]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \({0.106311607982883171`, 0.11981442242192668`, 0.0936143425291026254`, 
      0.0691786631952762043`, 0.0506929140158841295`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[e[m], \ {m, 2, 20, 2}] // N\)], "Input"],

Cell[BoxData[
    \({0.106311607982883171`, 0.11981442242192668`, 0.0936143425291026254`, 
      0.0691786631952762043`, 0.0506929140158841295`, 0.0373019500162321593`, 
      0.0276693152312801249`, 0.0207106026294488909`, 0.0156426613000966741`, 
      0.0119173507579212301`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[e[m], \ {m, 4, 120, 4}] // N\)], "Input"],

Cell[BoxData[
    \({0.11981442242192668`, 0.0691786631952762043`, 0.0373019500162321593`, 
      0.0207106026294488909`, 0.0119173507579212301`, 0.0070833872581701307`, 
      0.00433022174503805334`, 0.00271226029896788123`, 
      0.00173512949722474996`, 0.00113080467515406679`, 
      0.000749160363022960495`, 0.000503649039669652598`, 
      0.000343088836760434068`, 0.000236520604894476926`, 
      0.000164836398468782707`, 0.000116027593048970123`, 
      0.0000824230005487960504`, 0.0000590490565218590468`, 
      0.0000426372898795868948`, 0.000031012977086230582`, 
      0.0000227125302508890047`, 0.0000167405125098065044`, 
      0.0000124132367544479382`, 9.25683698211823724`*^-6, 
      6.94007102639534156`*^-6, 5.22954353652026071`*^-6, 
      3.95956943215202894`*^-6, 3.01170072090171814`*^-6, 
      2.30069584690514927`*^-6, 1.76482481495981087`*^-6}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[e[m], \ {m, 10, 120, 10}] // N\)], "Input"],

Cell[BoxData[
    \({0.0506929140158841295`, 0.0119173507579212301`, 
      0.00341738519641744842`, 0.00113080467515406679`, 
      0.00041503769530704293`, 0.000164836398468782707`, 
      0.0000696928739722633849`, 0.000031012977086230582`, 
      0.0000144048952227094417`, 6.94007102639534156`*^-6, 
      3.45134699330081184`*^-6, 1.76482481495981087`*^-6}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 207, 3, 59, "Input"],
Cell[1949, 56, 248, 4, 94, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2234, 65, 37, 1, 27, "Input"],
Cell[2274, 68, 158, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2469, 75, 66, 1, 27, "Input"],
Cell[2538, 78, 292, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2867, 87, 67, 1, 27, "Input"],
Cell[2937, 90, 893, 14, 120, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3867, 109, 69, 1, 27, "Input"],
Cell[3939, 112, 376, 6, 58, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

